package gov.va.med.mhv.vitals.web.validator;

import java.math.BigDecimal;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

@FacesValidator(value="INRValidator")
public class INRValidator implements Validator{
	private static final BigDecimal INRVALUE_MIN_VALUE = new BigDecimal("0.1");
	private static final BigDecimal INRVALUE_MAX_VALUE = new BigDecimal("99.9");

	@Override
	public void validate(FacesContext context, UIComponent component,
			Object value) throws ValidatorException {
		
         BigDecimal inr=(BigDecimal)value;
		
		if(inr.compareTo(INRVALUE_MAX_VALUE) > 0){
			String summary = "The INR value must be less than or equal to 99.9.";
			String detail = "Enter a value less than or equal to 99.9.";
			throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, detail));
		}else  if(inr.compareTo(INRVALUE_MIN_VALUE) < 0){
			String summary = "The INR value must be greater than or equal to 0.1.";
			String detail = "Enter a value greater than or equal to 0.1.";
			throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, detail));
		}
		
	}

}
